#ifndef _2INCH9_EPD_H_
#define _2INCH9_EPD_H_

#define EPD_WIDTH   168
#define EPD_HEIGHT  384
#define EPD_ARRAY  EPD_WIDTH*EPD_HEIGHT/4

#define SOURCE_BITS     168
#define GATE_BITS   384
#define ALLSCREEN_BYTES  16128 

//define pin conection in BCM number
#define PIN_CS      8   
#define PIN_RST     17  
#define PIN_DC      25   
#define PIN_BUSY    24 

#define G_BLACK 0x00
#define G_WHITE 0x01
#define YELLOW 0x02
#define RED 0x03


#define  EPD_2IN9G_BLACK   0x0
#define  EPD_2IN9G_WHITE   0x1
#define  EPD_2IN9G_YELLOW  0x2
#define  EPD_2IN9G_RED     0x3


void EPD_GPIO_Init(void);

//EPD
void Epaper_READBUSY(void);
void Epaper_Write_Command(unsigned char cmd);
void Epaper_Write_Data(unsigned char data);


void Epaper_HW_SW_RESET(void);
void EPD_HW_Init(void); //Electronic paper initialization
void EPD_Update(void);
void EPD_WhiteScreen_White(void);
void EPD_WhiteScreen_black(void);
void EPD_DeepSleep(void);
void EPD_WhiteScreen_Red(void);
void EPD_WhiteScreen_Yellow(void);
void PIC_display(const unsigned char* picData);
void GUI_display(unsigned char* picData);
#endif
/***********************************************************
						end file
***********************************************************/


